*== F9GUID
*== Create a new GUID character string,
*== optionally retaining the declared Windows functions
LPARAMETERS tlNoClear
LOCAL lcBuffer, ;
	lcReturnValue, ;
	llNoClear, ;
	lnFuncVal

*-- Define local variables
lcBuffer      = REPLICATE( CHR( 0 ), 256 )
lcReturnValue = []
llNoClear     = IIF( PCOUNT() > 0 AND VARTYPE( tlNoClear ) = "L", ;
			tlNoClear, ;
			.f. ;
		)
lnFuncVal     = 0

*-- Declare DLL functions
DECLARE INTEGER CoCreateGuid ;
	IN Ole32.DLL ;
	STRING @pGuid
DECLARE INTEGER StringFromGUID2 ;
	IN Ole32.DLL ;
	STRING rguid, STRING @lpsz, INTEGER cchMax

*-- Initialize a buffer to hold the GUID value
pGuid = REPLICATE( CHR( 0 ), 17 )

*-- Call the CoCreateGuid function
lnFuncVal = CoCreateGuid( @pGuid )

*-- If the DLL function returned zero,
*-- the function was successful,
*-- so build a string of the GUID data
IF lnFuncVal = 0
	= StringFromGUID2( pGuid, @lcBuffer, 128 )

	*-- Truncate the GUID string to the desired length
	lcBuffer = SUBSTR( lcBuffer, ;
				1, ;
				AT( CHR( 0 ) + CHR( 0 ), lcBuffer ) ;
			)

	*-- Convert the string
	lcReturnValue = STRCONV( lcBuffer, 6 )

ENDIF && lnFuncVal = 0

*-- Unless the calling module chose not to,
*-- clear the instantiated DLLs from memory
IF !llNoClear
	CLEAR DLLS "StringFromGUID2"
	CLEAR DLLS "CoCreateGuid"

ENDIF && !tlNoClear

*-- Clean up and return
RETURN ( lcReturnValue )

*== End module F9GUID
