**************************************************
*-- Class:        reporthandler (c:\proiecte\vfpexportutility\vfpexport_10112010\class\bzreporthandler.vcx)
*-- ParentClass:  session
*-- BaseClass:    
*-- Time Stamp:   12/08/10 11:31:02 PM
*
#INCLUDE "..\include\nosij.h"
*

*!*	DEFINE CLASS ReportBand AS session
*!*		
*!*		BandObjects = .f.
*!*		Expression = ""
*!*		BandType = 0
*!*		BandTypeName = ""
*!*		BandName = ""
*!*		BandStart = 0
*!*		BandEnd = 0
*!*		BandHeight = 0	
*!*		
*!*		PROCEDURE Init
*!*			DIMENSION BandObjects(1)
*!*		ENDPROC 
*!*		
*!*		PROCEDURE BandEnd_access
*!*			*To do: Modify this routine for the Access method
*!*			RETURN THIS.BandStart + THIS.BandHeight
*!*		ENDPROC

*!*	ENDDEFINE

DEFINE CLASS ReportObjectPropertyContainer as session

	PROCEDURE Init
		LPARAMETERS reportPath
		this.ReportPath = reportPath
		
		DO CASE
			CASE  ObjType= ID_LABEL 
				this.CreateLabelObject()
				
			CASE  ObjType= ID_LINE 
				this.CreateLineObject()

			CASE  ObjType= ID_SHAPE 
				this.CreateShapeObject()

			CASE  ObjType= ID_FIELD 
				this.CreateFieldObject()

			CASE  ObjType= ID_BITMAP 
				this.CreateBitmapObject()
		ENDCASE 
		
		this.SetupSizeAndLocation()		
		This.SetForeColor()
		this.SetBackColor()
		
		this.Comment = this.TrimExtraQuotes(Comment)
		this.BackStyle = Mode
		
	ENDPROC
	
	PROTECTED PROCEDURE SetForeColor
		IF PENRED =-1 OR PENBLUE = -1 OR PENGREEN=-1 then
			this.ForeColor = ""
		ELSE
			this.ForeColor = TRANSFORM(PENRED) +","+ TRANSFORM(PENGREEN) +","+ TRANSFORM(PENBLUE)
		ENDIF	
	ENDPROC 
	
	PROTECTED PROCEDURE SetBackColor
		IF FILLRED =-1 OR FILLBLUE = -1 OR FILLGREEN=-1 then
			this.BackColor = ""
		ELSE
			this.BackColor = TRANSFORM(FILLRED) +","+ TRANSFORM(FILLGREEN) +","+ TRANSFORM(FILLBLUE)
		ENDIF	
	ENDPROC 

	PROTECTED PROCEDURE SetupDrawMode
		this.PenSize = pensize
		this.PenPattern = PENPAT		
	ENDPROC 
	
	PROTECTED PROCEDURE SetupFont
		this.FontName = FontFace
		this.FontBold = BITAND(FontStyle, 1)
		this.FontItalic = BITAND(FontStyle, 2)
		this.FontUnderline = BITAND(FontStyle, 4)
		this.FontStrikethru = BITAND(FontStyle, 128)
		this.FontSize = FontSize		
	ENDPROC 

	PROTECTED PROCEDURE SetupSizeAndLocation
		this.Left = INT((HPOS * PIXEL_RATIO)+0.5)
		this.AbsoluteTop = INT((VPOS * PIXEL_RATIO)+0.5)
		this.Height = INT((HEIGHT * PIXEL_RATIO)+0.5)
		this.Width = INT((WIDTH * PIXEL_RATIO)+0.5)
	ENDPROC  

	PROTECTED PROCEDURE CreateLabelObject
		this.ObjectTypeName = "Label"	
		this.Caption = this.TrimExtraQuotes(EXPR)
		this.Alignment = Offset 
		this.SetupFont()
	ENDPROC 
	
	PROTECTED PROCEDURE CreateLineObject
		this.ObjectTypeName = "Line"
		this.SetupDrawMode()	
	ENDPROC 
	
	PROTECTED PROCEDURE CreateShapeObject
		this.ObjectTypeName = "Shape"	
		this.SetupDrawMode()
		this.FillPattern = FILLPAT
	ENDPROC 
	
	PROTECTED PROCEDURE CreateFieldObject
		this.ObjectTypeName = "Field"	
		this.ControlSource = this.TrimExtraQuotes(EXPR)
		this.Alignment = Offset 
		this.SetupFont()
	ENDPROC 
	
	PROTECTED PROCEDURE CreateBitmapObject
		
		PRIVATE ALL LIKE l*
		this.ObjectTypeName = "Bitmap"	
		
		*-- Offest 
		*-- 1 -> picture comes from database
		*-- 0 -> from file
		DO CASE 
			CASE Offset = 1
				this.ControlSource = ALLTRIM(name)
			CASE Offset = 0
				lcPath = ALLTRIM(picture)
				lcPath = this.TrimExtraQuotes(lcPath)
				this.Picture = CombinePath(this.ReportPath, lcPath)
		ENDCASE 
	ENDPROC
	
	HIDDEN FUNCTION  TrimExtraQuotes
		LPARAMETERS strMsg
		strMsg = ALLTRIM(strMsg)
		IF LEFT(strMsg, 1)=["]
			strMsg = SUBSTR(strMsg, 2, LEN(strMsg)-2)
		ENDIF
		RETURN strMsg
	ENDFUNC 
	
	PROCEDURE AddObjectToBand
		LPARAMETERS bands as Collection
		PRIVATE ALL LIKE l*
		LOCAL loBand as banddescriptor OF HOME()+"..\..\proiecte\vfpexportutility\vfpexport_10112010\class\bzreporthandler.vcx"
		lnSplitterSize = 20	&&INT((BAND_SPLITTER_HEIGHT * PIXEL_RATIO)+0.5)
		lnSplitterOffset = 0 
		FOR lni = 1 TO bands.Count
			loBand = bands.Item(lni)
			IF this.AbsoluteTop < loband.getbandend() + lnSplitterOffset then
				this.Top = this.AbsoluteTop - lnSplitterOffset 
				this.BandParent = loBand.bandname
				loBand.Add(this)
				EXIT
			ELSE
				lnSplitterOffset = lnSplitterOffset + lnSplitterSize
			ENDIF
		NEXT 
	ENDPROC 

	PROCEDURE SetObjectName
		LPARAMETERS ID as Integer
		this.ObjectName = this.ObjectTypeName + TRANSFORM(id)
	ENDPROC 
	
	FUNCTION GetObjectName() as String
		RETURN this.ObjectName
	ENDPROC 

	FUNCTION GetObjectType() as String
		RETURN this.ObjectTypeName
	ENDPROC 

	DataSession = 1
	Caption = ""
	Alignment = ""
	Left = 0
	Top = 0
	Height = 0
	Width = 0
	Picture = ""
	ForeColor = ""
	BackColor = ""
	BorderWidth = ""
	PenSize = ""
	PenPattern = ""
	FillPattern = ""
	BackStyle = ""
	FontName = ""
	FontBold = ""
	FontItalic = ""
	FontUnderline = ""
	FontStrikethru = ""
	FontSize =""
	ControlSource =""
	Comment = ""
	
	HIDDEN ObjectName
	HIDDEN ObjectTypeName
	HIDDEN BandParent
	HIDDEN AbsoluteTop
	HIDDEN reportPath
		
ENDDEFINE 