LPARAMETERS targetObject, skipEmpty, allProperties, aProps
*-- return string with serialized properties or empty string

#INCLUDE "..\include\nosij.h"

PRIVATE ALL LIKE l*

EXTERNAL ARRAY aProps

lcPropContent = ""

IF VARTYPE(targetObject)="O" THEN 

	*-- if passing in array with properties, use that
	IF TYPE("aProps", 1) == "A"
		lnProps = ACOPY(aProps, laProps)
	ELSE 
		IF allProperties
			*-- extract properties
			lnProps = AMEMBERS(laProps, targetObject, 0, "G")
		ELSE 
			*-- extract properties
			lnProps = AMEMBERS(laProps, targetObject, 0, "G+U")
		ENDIF
	ENDIF
		
	FOR lni = 1 TO lnProps
		lcPropName = laProps(lni)

		*-- delim for string properties
		lcDelimStart =[]
		lcDelimEnd =[]

		TRY 
			lVal = targetObject.&lcPropName.
			IF VARTYPE(lVal)="C" ;
				.AND. .NOT. "COLOR"$UPPER(lcPropName) ;
				.AND. .NOT. "PICTURE"$UPPER(lcPropName) ;
				.AND. .NOT. "MOUSEICON"$UPPER(lcPropName)

				IF INLIST(LOWER(lcPropName), "comment", "tooltiptext")
					lVal = STRCONV(STRCONV(lVal, 5), 10)
				ENDIF 
				IF LEFT(lVal, 1) <> ["] then
					lcDelimStart =["]
					lcDelimEnd =["]
				ENDIF 
			ENDIF 			
		CATCH
			lVal =""
		ENDTRY
		
		lcVal = TRIM(TRANSFORM(lVal))
		IF (skipEmpty .AND. lcVal<>"") .or. NOT skipEmpty
			lcPropContent = lcPropContent + lcPropName + " = " + lcDelimStart + lcVal + lcDelimEnd + CRLF
		ENDIF
	NEXT 
ENDIF  

RETURN lcPropContent 
